#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

_Bool parnostBrojeva(unsigned broj1, unsigned broj2)
{
    if(broj1%2==broj2%2)
        return true;
    return false;
}

unsigned srecaMatrice(unsigned N, unsigned matrica[2][N]) {
    unsigned sreca = 0;

    for (unsigned k = 0; k < N; ++k) {
        // kroz svaku kolonu se ide
        for (unsigned j = 0; j < 1; ++j){
            // ako je trenutni i sledeci element iste parnosti
            if ((matrica[j][k] % 2 == 0 && matrica[j + 1][k] % 2 == 0) ||
                (matrica[j][k] % 2 == 1 && matrica[j + 1][k] % 2 == 1)) {
                // koriguje se sreca
                ++sreca;
            }
        }
        // ide se u sledecu kolonu i proverava i koriguje po potrebi
        if (k < N - 1) {
            if(parnostBrojeva(matrica[1][k],matrica[0][k + 1]) ||
               parnostBrojeva(matrica[1][k],matrica[0][k + 1])) {
                ++sreca;
            }
        }
    }
    // vraca se izracunata sreca
    return sreca;
}

void sortirajMatricu(unsigned N, unsigned matrica[2][N]) {
    for (unsigned k = 0; k < N; ++k) {
        // cuva se sreca pre menjanja
        unsigned srecaPre = srecaMatrice(N, matrica);

        // Smenjaju se
        unsigned pom = matrica[0][k];
        matrica[0][k] = matrica[1][k];
        matrica[1][k] = pom;

        // racuna se nova sreca
        unsigned novaSreca = srecaMatrice(N, matrica);

        // ako nova sreca nije veca, vrati promenu
        if (novaSreca <= srecaPre) {
            pom = matrica[0][k];
            matrica[0][k] = matrica[1][k];
            matrica[1][k] = pom;
        }
    }
}

int main()
{
    unsigned brojTestova;
    scanf("%u", &brojTestova);

    unsigned zbir[1000]={0};

    // ponavljanje za unesen broj test primera
    for(int i=0;i<brojTestova;i++)
    {
        // komande za jedan test primer
        unsigned N;
        scanf("%u", &N);


        // unos prvog i drugog reda matrice
        unsigned matrica[2][N];
        for(int j=0;j<2; j++){
            for(int k=0;k<N;k++){
                scanf("%u", &matrica[j][k]);
            }
        }

        sortirajMatricu(N, matrica);
        zbir[i]=srecaMatrice(N, matrica);
    }

    for(int i;i<brojTestova;i++){
        printf("%u\n", zbir[i]);
    }
    return 0;
}